﻿#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage, 
		    [Parameter(Mandatory=$false)]
		    $Component, 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage.Replace("`0","") | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

#Setup TS Environment
try
{
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
}
catch
{
	Write-Verbose "Not running in a task sequence."
}

$LogPath = $tsenv.Value('_SMSTSLogPath')
$LogFile = "$LogPath\WaaS_LangPack.log"

$Mode = $tsenv.Value('SMSTS_TSWaaSMode')
if ($Mode -ne $null){$Component = "$($mode):LangPack"}
else {$Component = "LangPack"}


$LangCabs = Get-ChildItem "$($tsenv.Value('LANG01'))\Offline\*.cab"
$LangCabs += Get-ChildItem "$($tsenv.Value('LANG01'))\Online\*.cab"

Start-Sleep -Seconds 1
CMTraceLog -Message "" -Type 1 -LogFile $LogFile
CMTraceLog -Message " Starting Language FOD Online Script" -Type 1 -LogFile $LogFile -Component $Component
Start-Sleep -Seconds 1
foreach ($LangCab in $LangCabs)
    {
    $DISMArgs = "/Online /Add-Package /PackagePath=""$LangCab"""
    Write-Output 'Dism.exe' "$DISMArgs"
    CMTraceLog -Message  "  Dism.exe $DISMArgs" -Type 1 -LogFile $LogFile -Component $Component
    Start-Process DISM -ArgumentList $DISMArgs -Wait
    }
Start-Sleep -Seconds 1
CMTraceLog -Message "Finished Language FOD Online Script" -Type 1 -LogFile $LogFile -Component $Component